/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.api.v2.generator;

import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_1959;
import net.minecraft.class_2378;
import net.minecraft.class_2919;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import org.betterx.bclib.api.v2.levelgen.biomes.BCLBiome;
import org.betterx.bclib.api.v2.levelgen.biomes.BCLBiomeRegistry;
import org.betterx.bclib.util.WeighTree;
import org.betterx.bclib.util.WeightedList;

public class BiomePicker {
    private final Map<BCLBiome, ActualBiome> all = new HashMap<BCLBiome, ActualBiome>();
    public final class_2378<class_1959> biomeRegistry;
    private final List<ActualBiome> biomes = Lists.newArrayList();
    private final List<String> allowedBiomes;
    public final ActualBiome fallbackBiome;
    private WeighTree<ActualBiome> tree;

    public BiomePicker(class_2378<class_1959> biomeRegistry) {
        this(biomeRegistry, null);
    }

    public BiomePicker(class_2378<class_1959> biomeRegistry, List<class_6880<class_1959>> allowedBiomes) {
        this.biomeRegistry = biomeRegistry;
        this.allowedBiomes = allowedBiomes != null ? allowedBiomes.stream().map(h -> h.method_40230()).filter(o -> o.isPresent()).map(o -> ((class_5321)o.get()).method_29177().toString()).toList() : null;
        this.fallbackBiome = this.create(BCLBiomeRegistry.EMPTY_BIOME);
    }

    private boolean isAllowed(BCLBiome b) {
        if (this.allowedBiomes == null) {
            return true;
        }
        return this.allowedBiomes.contains(b.getID().toString());
    }

    private ActualBiome create(BCLBiome bclBiome) {
        ActualBiome e = this.all.get(bclBiome);
        if (e != null) {
            return e;
        }
        return new ActualBiome(bclBiome);
    }

    public void addBiome(BCLBiome biome) {
        this.biomes.add(this.create(biome));
    }

    public ActualBiome getBiome(class_2919 random) {
        return this.biomes.isEmpty() ? this.fallbackBiome : this.tree.get(random);
    }

    public boolean isEmpty() {
        return this.biomes.isEmpty();
    }

    public void rebuild() {
        ActualBiome biome2;
        WeightedList<ActualBiome> list = new WeightedList<ActualBiome>();
        this.biomes.forEach(biome -> {
            if (biome.isValid) {
                list.add((ActualBiome)biome, biome.bclBiome.getGenChance());
            }
        });
        if (list.size() == 1 && (biome2 = (ActualBiome)list.get(0)).getEdge() != null) {
            float defaultBiomeSize = 128.0f;
            float edgeSize = (float)biome2.bclBiome.getEdgeSize() * list.getWeight(0) / defaultBiomeSize;
            list.add(biome2.getEdge(), edgeSize);
        }
        if (list.isEmpty()) {
            list.add(this.create(BCLBiomeRegistry.EMPTY_BIOME), 1.0f);
        }
        this.tree = new WeighTree(list);
    }

    public String toString() {
        return "BiomePicker{biomes=" + this.biomes.size() + " (" + this.all.size() + "), biomeRegistry=" + this.biomeRegistry + ", type=" + super.toString() + "}";
    }

    public class ActualBiome {
        public final BCLBiome bclBiome;
        public final class_6880<class_1959> biome;
        public final class_5321<class_1959> key;
        private final WeightedList<ActualBiome> subbiomes = new WeightedList();
        private final ActualBiome edge;
        private final ActualBiome parent;
        public final boolean isValid;

        private ActualBiome(BCLBiome bclBiome) {
            BiomePicker.this.all.put(bclBiome, this);
            this.bclBiome = bclBiome;
            this.key = BiomePicker.this.biomeRegistry.method_29113((Object)((class_1959)BiomePicker.this.biomeRegistry.method_10223(bclBiome.getID()))).orElse(null);
            this.biome = this.key != null ? BiomePicker.this.biomeRegistry.method_44298(this.key) : null;
            this.isValid = this.key != null && this.biome != null && this.biome.method_40227();
            bclBiome.forEachSubBiome((b, w) -> {
                if (BiomePicker.this.isAllowed((BCLBiome)b)) {
                    this.subbiomes.add(BiomePicker.this.create((BCLBiome)b), w.floatValue());
                }
            });
            this.edge = bclBiome.getEdge() != null && BiomePicker.this.isAllowed(bclBiome.getEdge()) ? BiomePicker.this.create(bclBiome.getEdge()) : null;
            this.parent = bclBiome.getParentBiome() != null ? BiomePicker.this.create(bclBiome.getParentBiome()) : null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ActualBiome entry = (ActualBiome)o;
            return this.bclBiome.equals(entry.bclBiome);
        }

        public int hashCode() {
            return Objects.hash(this.bclBiome);
        }

        public ActualBiome getSubBiome(class_2919 random) {
            return this.subbiomes.get((class_5819)random);
        }

        public ActualBiome getEdge() {
            return this.edge;
        }

        public ActualBiome getParentBiome() {
            return this.parent;
        }

        public boolean isSame(ActualBiome e) {
            return this.bclBiome.isSame(e.bclBiome);
        }

        public String toString() {
            return "ActualBiome{key=" + this.key.method_29177() + ", subbiomes=" + this.subbiomes.size() + ", edge=" + (Comparable)(this.edge != null ? this.edge.key.method_29177() : "null") + ", parent=" + (Comparable)(this.parent != null ? this.parent.key.method_29177() : "null") + ", isValid=" + this.isValid + "}";
        }
    }
}

